﻿<%@ Page Language="c#" Title="Login" MasterPageFile="~/Templates/MasterPages/public.master"
    Inherits="Asi.ContentManagerNet.DisplayPageBase" %>

<script runat="Server">
    protected override void OnLoad(EventArgs e)
    {
        base.OnLoad(e);
        String domain = "abc.org";
        String communitySite = "http://community.exampletenant.org";
        String webserviceUrl = "https://[exampledomain]/HigherLogic/HigherLogicWebService.asmx";
        String webserviceToken = "691B40C6-88A3-4A05-9C47-BF893AA4DAEC";
        string checkOnly = Request.QueryString["CheckOnly"];

                    
         if (Asi.ContentManagerNet.SessionState.IsLoggedIn)
             {
                 Asi.iBO.ContactManagement.CContact user = Asi.ContentManagerNet.SessionState.Contact;
            

            try
            {
                String ReturnURL = Request["Redirect"];

                string requestBody = @"
                    <soapenv:Envelope xmlns:soapenv=""http://schemas.xmlsoap.org/soap/envelope/"" xmlns:hig=""http://higherlogic.com/"">
                       <soapenv:Header/>
                       <soapenv:Body>
                          <hig:Authorize>
                             <hig:securityKey>{0}</hig:securityKey>
                             <!--Optional:-->
                             <hig:memberKey>{1}</hig:memberKey>
                          </hig:Authorize>
                       </soapenv:Body>
                    </soapenv:Envelope>";

                byte[] buffer = System.Text.Encoding.UTF8.GetBytes(string.Format(requestBody, webserviceToken, user.ContactId));
                System.Net.HttpWebRequest webRequest = System.Net.HttpWebRequest.Create(webserviceUrl) as System.Net.HttpWebRequest;
                webRequest.Accept = "text/xml";
                webRequest.ContentLength = buffer.Length;
                webRequest.ContentType = "text/xml;charset=\"utf-8\"";
                webRequest.Method = "POST";
                using (System.IO.Stream stream = webRequest.GetRequestStream())
                    stream.Write(buffer, 0, buffer.Length);
                System.Net.HttpWebResponse webResponse = webRequest.GetResponse() as System.Net.HttpWebResponse;
                buffer = new byte[webResponse.ContentLength];
                using (System.IO.Stream stream = webResponse.GetResponseStream())
                    stream.Read(buffer, 0, buffer.Length);
                string responseBody = System.Text.Encoding.UTF8.GetString(buffer);
                int start = responseBody.IndexOf("<AuthorizeResult>", StringComparison.InvariantCultureIgnoreCase) + 17;
                int end = responseBody.IndexOf("</AuthorizeResult>", StringComparison.InvariantCultureIgnoreCase) - 1;
                Guid memberToken = Guid.Empty;
                if (start >= 17 && end > start)
                    memberToken = new Guid(responseBody.Substring(start, end - start + 1));

                HttpCookie cookieToken = new HttpCookie("MemberToken", memberToken.ToString());
                cookieToken.Domain = domain;
                cookieToken.Expires = DateTime.Now.AddHours(4);
                Response.Cookies.Add(cookieToken);
                HttpCookie cookie = HttpContext.Current.Request.Cookies["Login"];
                if (cookie != null)
                {
                    HttpContext.Current.Response.Cookies["Login"].Expires = DateTime.Now.AddDays(-1);
                    HttpContext.Current.Response.Cookies.Remove(cookie.Name);
                }

                Response.Redirect(String.Format("{0}/HigherLogic/Security/ImisLogin.aspx?LoginKey={1}&ReturnURL={2}", communitySite, Server.UrlEncode(memberToken.ToString()), Server.UrlEncode(ReturnURL)));
            }
            catch (Exception)
            {
            }

            HttpCookie cookieID = new HttpCookie("MemberID", user.ContactId);
            cookieID.Domain = domain;
            cookieID.Expires = DateTime.Now.AddHours(40);
            Response.Cookies.Add(cookieID);
            if (Request["Redirect"] != null)
                Response.Redirect(Request["Redirect"]);
            Response.Redirect(communitySite);
        }
        else if (!string.IsNullOrEmpty(checkOnly))
        {
            if (Request["Redirect"] != null)
                Response.Redirect(Request["Redirect"]);
            Response.Redirect(communitySite);
            
        }
        else
        {
            if (Request["Redirect"] != null)
            {
                System.IO.StringWriter writer = new System.IO.StringWriter();
                Server.UrlEncode(Request["Redirect"], writer);
                String redirect = writer.ToString();
                System.IO.StringWriter writer2 = new System.IO.StringWriter();
                Server.UrlEncode(redirect, writer2);
                redirect = writer2.ToString();

                Response.Redirect(String.Format("https://example.tenant.org/EXAMPLEPATH/Sign_In.aspx?ReturnUrl={0}%3FRedirect={1}", Server.UrlEncode(Request.Url.AbsolutePath), redirect));
            }
        }
    }

</script>

