﻿<%@ Page Language="c#" Title="iMIS Login" MasterPageFile="~/Templates/MasterPages/public.master"
    Inherits="Asi.ContentManagerNet.DisplayPageBase" %>

<script runat="Server">
    protected override void OnLoad(EventArgs e)
    {
        //Delete cookies
        int count = 0;
        string cookieNames = "UserID;FirstName;LastName;Company_ID;Email;Organization;SecurityGroup;MemberID";
        count = Request.Cookies.Count;
        HttpCookie cookie;
        for (int i = 0; i < count; i++)
        {
            cookie = Request.Cookies[i];
            if (!cookie.Value.Equals(Session.SessionID))
            {
                if (cookieNames.ToUpper().Contains(cookie.Name.ToUpper()))
                {
                    cookie.Expires = DateTime.Now.AddDays(-1);
                    Response.Cookies.Add(cookie);
                }
            }
        }
        Request.Cookies.Clear();

        // Higher Logic code to remove the login cookie we added
        Response.Cookies.Remove("MemberID");
        HttpCookie hlcookie = new HttpCookie("MemberID", "");
        hlcookie.Domain = "abc.org";
        hlcookie.Expires = DateTime.Now.AddHours(-4);
        Response.Cookies.Add(hlcookie);

        Session.Abandon();
        FormsAuthentication.SignOut();
        //Asi.Web.Security.ClearCookies(HttpContext.Current); //Will remove the Login iMIS HttpOnly cookie
        if (Request["Redirect"] != null)
            Response.Redirect(Request["Redirect"]);
        Response.Redirect(System.Web.Security.FormsAuthentication.DefaultUrl);
    }

</script>

