﻿using System;
using System.Configuration;
using System.Web.Services;
using Asi.iBO;
using Asi.iBO.ContactManagement;
using AccessViolationException = System.AccessViolationException;

[WebService(Namespace = "http://higherlogic.com/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class LibraryUpdateWebService : WebService
{
    private static IiMISUser _iMISUser = null;

    private static bool CheckSecurity(string securityKey)
    {
        return securityKey == ConfigurationManager.AppSettings["SecurityKey"];
    }

    [WebMethod(Description = "Records new library entries created in libraries that are tracked for chapter document uploads.", EnableSession = false)]
    public int AddLibraryFile(string securityKey, string memberKey, string libraryName, string documentName, DateTime uploadDateTime, string permalink, string updatedByMemberKey)
    {
        if (!CheckSecurity(securityKey))
            throw new AccessViolationException("Unauthorized Access.");
        if (!iboAdmin.IsSystemInitialized)
            iboAdmin.InitializeSystem();

        CContact contact = new CContact(iMISUser, memberKey);

        foreach (CExtTable table in contact.ExtTables)
        {
            if (table.TableName.Equals("LibraryFiles", StringComparison.InvariantCultureIgnoreCase))
            {
                CExtTable newRow = table.NewInstance(contact);
                CExtField libraryNameField = newRow.GetField("LibraryName");
                CExtField documentNameField = newRow.GetField("Document_Name");
                CExtField uploadedDateTimeField = newRow.GetField("UploadedDateTime");
                CExtField permalinkField = newRow.GetField("Permalink");
                CExtField postedIDField = newRow.GetField("PostedID");

                libraryNameField.FieldValue = libraryName;
                documentNameField.FieldValue = documentName;
                uploadedDateTimeField.FieldValue = uploadDateTime;
                permalinkField.FieldValue = permalink;
                postedIDField.FieldValue = updatedByMemberKey;

                contact.Save();
                return newRow.SequenceNumber;
            }
        }
        return 0;
    }

    [WebMethod(Description = "Updates existing library entries to indicate when they are updated or deleted for libraries that are tracked for chapter document uploads.", EnableSession = false)]
    public int UpdateLibraryFile(string securityKey, string memberKey, int sequenceNumber, string documentName, DateTime updateDateTime, bool isDelete)
    {
        if (!CheckSecurity(securityKey))
            throw new AccessViolationException("Unauthorized Access.");
        if (!iboAdmin.IsSystemInitialized)
            iboAdmin.InitializeSystem();

        CContact contact = new CContact(iMISUser, memberKey);

        foreach (CExtTable table in contact.ExtTables)
        {
            if (table.TableName.Equals("LibraryFiles", StringComparison.InvariantCultureIgnoreCase))
            {
                CExtTable newRow = null;
                for (int i = 0, ic = table.InstancesCount; i < ic; i++)
                {
                    newRow = table.GetInstance(i);
                    if (newRow != null && newRow.SequenceNumber == sequenceNumber)
                        break;
                }

                if (newRow != null && newRow.SequenceNumber == sequenceNumber)
                {
                    if (isDelete)
                    {
                        CExtField deletedDateTime = GetField(newRow, "DeletedDateTime");
                        if (deletedDateTime != null)
                            deletedDateTime.FieldValue = updateDateTime;
                    }
                    else
                    {
                        CExtField uploadedDateTime = GetField(newRow, "UploadedDateTime");
                        if (uploadedDateTime != null)
                            uploadedDateTime.FieldValue = updateDateTime;

                        CExtField documentNameField = GetField(newRow, "Document_Name");
                        if (documentNameField != null)
                            documentNameField.FieldValue = documentName;
                    }

                    contact.Save();
                    return newRow.SequenceNumber;
                }
            }
        }
        return 0;
    }

    // get field doesn't seem to work all the time.  So I had to write my own.
    private CExtField GetField(CExtTable row, string columnName)
    {
        CExtField[] fields = row.Fields;
        if (fields != null)
            foreach (CExtField field in fields)
                if (field.FieldName.ToLower() == columnName.ToLower())
                    return field;
        return null;
    }

    private static IiMISUser iMISUser
    {
        get
        {
            if (_iMISUser == null)
            {
                _iMISUser = CStaffUser.Login(ConfigurationManager.AppSettings["System.WebLogin"], ConfigurationManager.AppSettings["System.WebPassword"]);
                _iMISUser.ThrowExceptionOnError = true;
            }
            return _iMISUser;
        }
    }
}

