﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RealMagnet.TrackingAPI
{
	static class Program
	{
		static void Main( string[] args )
		{
			const string MailUserId = "YourAccount";
			const string ApiKey = "abcdefghiklmnopqrstuvwxyz";

			TrackingResponse response = null;
			var start_date = GetReasonableTrackingStartDate();
			string tracking_type = "email-open";
			long? start_id = null;
			int i = 0;

			var client = new TrackingApiClient(MailUserId, ApiKey) { Timeout = 240000 };

			if (1 <= args.Length && !string.IsNullOrEmpty(args[0]))
				tracking_type = args[0];
			Console.WriteLine("Using tracking type '" + tracking_type + "'.");

			Console.WriteLine("Reset tracking state to start on {0:yyyy-MM-dd}", start_date);
			response = client.UpdateTrackingStreamState(tracking_type, starting_on: start_date.ToLongDateString());
			DumpResponse(response);
			if (IsError(response))
			{
				Console.WriteLine("Exiting due to error.");
				Environment.Exit(1);
			}


			Console.WriteLine("Stream first 500 tracking records.");
			response = client.StreamTrackingData(tracking_type, max_rows: 500);
			DumpResponse(response);
			if (IsError(response))
			{
				Console.WriteLine("Exiting due to error.");
				Environment.Exit(1);
			}

			Console.WriteLine("Stream next 5000 tracking records.");
			client.StreamTrackingData(tracking_type, max_rows: 5000);
			DumpResponse(response);
			if (IsError(response))
			{
				Console.WriteLine("Exiting due to error.");
				Environment.Exit(1);
			}

			Console.WriteLine("Get tracking in batches of 1000, starting at {0:yyyy-MM-dd}.", start_date);
			do
			{
				Console.WriteLine("Batch {0}.", ++i);
				response = client.GetTrackingDataInRange(tracking_type, starting_id: start_id, starting_on: start_date, max_rows: 1000);
				DumpResponse(response);
				if (IsError(response))
				{
					Console.WriteLine("Exiting due to error.");
					Environment.Exit(1);
				}
				start_id = response.NextStartId;
			}
			while (response.HasMore);
		}

		/// <summary>
		/// A reasonable starting date for tracking is the first day of last month.
		/// </summary>
		private static DateTime GetReasonableTrackingStartDate()
		{
			var start = DateTime.Now.Date;
			if (1 != start.Day)
				start = start.AddDays(-start.Day+1);
			start = start.AddMonths(-1);
			return start;
		}

		/// <summary>
		/// It is an error when no response is returned, or the response contains any message with "Error" severity.
		/// </summary>
		private static bool IsError( TrackingResponse response )
		{
			if (null == response)
				return true;
			if (null == response.Messages)
				return false;
			if (response.Messages.Any(x => (int)Severity.Error == x.Severity))
				return true;
			return false;
		}

		/// <summary>
		/// Write the response data, metadata & messages to console.
		/// </summary>
		private static void DumpResponse( TrackingResponse response )
		{
			if (null == response)
			{
				Console.WriteLine("No response.");
			}
			else
			{
				Console.WriteLine("NextStartId: {0}", response.NextStartId);
				Console.WriteLine("HasMore: {0}", response.HasMore);
				if (null != response.Fields)
					Console.WriteLine("Fields: {0}", string.Join(",",response.Fields));

				if (null != response.Data)
				{
					Console.WriteLine("Data: ");
					foreach (var data in response.Data.Take(5))
					{
						Console.Write("  ");
						foreach (var value in data)
						{
							Console.Write(value);
							Console.Write(",");
						}
						Console.WriteLine();
					}
				}

				if (null != response.Messages)
				{
					foreach (var status in response.Messages)
						Console.WriteLine("({1:G}) {0}", status.Message, (Severity)status.Severity);
				}
			}
		}
	}
}
